@extends('layouts.bayanihan')
@section('title','Complete Profile')

@section('content')

    <div class="page-wrapper" style="padding-top: 60px !important">
        <div class="container-fluid">
        	<div class="row">
                <div class="col-md-12 single-note-item all-category note-business">
                    <div class="card card-body">
                    	<form method="POST" action="{{ route('bayanihan.complete.profile') }}" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                               <div class="col-lg-3 col-12">
                                    <label>PHOTO</label>
                                    <input type="file" id="input-file-now-custom-2" name="image" value="{{ old('image')}}" class="dropify" data-height="300" data-allowed-file-extensions="jpeg png jpg" required />
                                    @error('image')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <p class="mt-2 text-center">Image must be square and at least 500x500 pixels</p>
                                </div>
                                <div class="col-lg-9 col-12">
                                    <h4 class="card-title mb-4">Personal Information</h4>
                                    <div class="row">
                                        <div class="col-lg-4 col-12 form-group">
                                            <label>First Name*</label>
                                            <input type="text" class="form-control @error('firstname') is-invalid @enderror" name="firstname" value="{{ old('firstname', Auth::user()->firstname) }}" placeholder="Enter first name" required>
                                            @error('firstname')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-lg-4 col-12 form-group">
                                             <label>Middle Name</label>
                                            <input type="text" class="form-control @error('middlename') is-invalid @enderror" name="middlename" value="{{ old('middlename') }}" placeholder="Enter middle name">
                                            @error('middlename')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-lg-4 col-12 form-group">
                                            <label>Last Name*</label>
                                             <input type="text" class="form-control @error('lastname') is-invalid @enderror" name="lastname" value="{{ old('lastname', Auth::user()->lastname) }}" placeholder="Enter last name" required>
                                            @error('lastname')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-lg-4 col-12 form-group">
                                            <label>Citizenship:*</label>
                                            <input type="text" class="form-control @error('citizenship') is-invalid @enderror" value="{{ old('citizenship') }}" placeholder="Enter citizenship" name="citizenship" required>
                                            @error('citizenship')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-lg-4 col-12 form-group">
                                            <label>Gender*</label>
                                            <select class="form-control @error('gender') is-invalid @enderror" name="gender" required>
                                                <option value="" disabled selected>Select Gender</option>
                                                <option value="Male" {{ old('gender') == 'Male' ? 'selected' : ''}}>Male</option>
                                                <option value="Female" {{ old('gender') == 'Female' ? 'selected' : ''}}>Female</option>
                                            </select>
                                            @error('gender')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-lg-4 col-12 form-group">
                                            <label>Marital Status*</label>
                                            <select class="form-control @error('marital_status') is-invalid @enderror" name="marital_status" required>
                                                <option value="" disabled selected>Select Marital Status</option>
                                                <option value="Single" {{ old('marital_status') == 'Single' ? 'selected' : ''}}>Single</option>
                                                <option value="Married" {{ old('marital_status') == 'Married' ? 'selected' : ''}}>Married</option>
                                                <option value="Divorced" {{ old('marital_status') == 'Divorced' ? 'selected' : ''}}>Divorced</option>
                                                <option value="Widowed" {{ old('marital_status') == 'Widowed' ? 'selected' : ''}}>Widowed</option>
                                            </select>
                                            @error('marital_status')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-lg-4 col-12 form-group">
                                            <label>Birth Date*</label>
                                            <input type="text" class="form-control @error('birthdate') is-invalid @enderror" value="{{ old('birthdate') }}" name="birthdate" id="birthdate" placeholder="mm/dd/yyyy" required>
                                            @error('birthdate')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-lg-4 col-12 form-group">
                                            <label>Mobile No.*</label>
                                            <input type="text" class="form-control @error('mobile_number') is-invalid @enderror" value="{{ old('mobile_number') }}" placeholder="Enter mobile number" name="mobile_number" required>
                                            @error('mobile_number')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-lg-4 col-12 form-group">
                                            <label>Landline No.</label>
                                            <input type="text" class="form-control @error('landline_number') is-invalid @enderror" value="{{ old('landline_number') }}" placeholder="Enter landline number" name="landline_number">
                                            @error('landline_number')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-lg-4 col-12 form-group">
                                            <label>Occupation*</label>
                                            <input type="text" class="form-control @error('occupation') is-invalid @enderror" value="{{ old('occupation') }}" placeholder="Enter occupation" name="occupation" required>
                                            @error('occupation')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-lg-4 col-12 form-group">
                                            <label>TIN No.</label>
                                            <input type="text" class="form-control @error('tin_number') is-invalid @enderror" value="{{ old('tin_number') }}" placeholder="Enter tin number" name="tin_number">
                                            @error('tin_number')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-lg-8 col-12 form-group">
                                            <label>Address*</label>
                                            <input type="text" class="form-control @error('address') is-invalid @enderror" id="autocomplete" onFocus="geolocate()" value="{{ old('address') }}" placeholder="Enter address" name="address" required>
                                            @error('address')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-lg-4 col-12 form-group">
                                           	<label>City/Municipality*</label>
                                            <input type="text" class="form-control @error('city') is-invalid @enderror" id="locality" value="{{ old('city') }}" placeholder="Enter city/municipality" name="city" required>
                                            @error('city')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-lg-4 col-12 form-group">
                                           	<label>Street #*</label>
                                            <input type="text" class="form-control @error('street_address') is-invalid @enderror" id="street_number" value="{{ old('street_address') }}" placeholder="Enter street" name="street_address" required>
                                            @error('street_address')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-lg-4 col-12 form-group">
                                           	<label>Building/Village*</label>
                                            <input type="text" class="form-control @error('building') is-invalid @enderror" id="building" value="{{ old('building') }}" placeholder="Enter building/village" name="building" required>
                                            @error('building')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                       	<div class="col-lg-4 col-12 form-group">
                                           	<label>Province*</label>
                                            <input type="text" class="form-control @error('province') is-invalid @enderror" id="administrative_area_level_2" value="{{ old('province') }}" placeholder="Enter province" name="province" required>
                                            @error('province')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-lg-12 col-12 form-group text-right">
                                            <button type="submit" class="btn btn-info">
                                                Complete Registration
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
	            </div>
	        </div>
    	</div>
  
        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
    <script type="text/javascript">
    	// All select option
        $('select').select2({
            width : '100%'
        })

        // Birthdate
        $('#birthdate').datepicker({
            endDate: '-5y',
            autoclose: true,
            todayHighlight: true
        });

        var placeSearch, autocomplete;

		var componentForm = {
			street_number: 'short_name',
			locality: 'long_name',
			administrative_area_level_2: 'short_name',
			// route: 'long_name',
			// administrative_area_level_1: 'short_name',
			// country: 'long_name',
			// postal_code: 'short_name'
		};

		function initAutocomplete() {
			// Create the autocomplete object, restricting the search predictions to
			// geographical location types.
			autocomplete = new google.maps.places.Autocomplete(
			document.getElementById('autocomplete'), {types: ['geocode']});

			// Avoid paying for data that you don't need by restricting the set of
			// place fields that are returned to just the address components.
			autocomplete.setFields(['address_component']);

			// When the user selects an address from the drop-down, populate the
			// address fields in the form.
			autocomplete.addListener('place_changed', fillInAddress);
		}

		function fillInAddress() {
			// Get the place details from the autocomplete object.
			var place = autocomplete.getPlace();

			for (var component in componentForm) {
				document.getElementById(component).value = '';
				document.getElementById(component).disabled = false;
			}

			// Get each component of the address from the place details,
			// and then fill-in the corresponding field on the form.
			for (var i = 0; i < place.address_components.length; i++) {
			var addressType = place.address_components[i].types[0];
				if (componentForm[addressType]) {
					var val = place.address_components[i][componentForm[addressType]];
					document.getElementById(addressType).value = val;
				}
			}
		}

		// Bias the autocomplete object to the user's geographical location,
		// as supplied by the browser's 'navigator.geolocation' object.
		function geolocate() {
			if (navigator.geolocation) {
				navigator.geolocation.getCurrentPosition(function(position) {
				var geolocation = {
					lat: position.coords.latitude,
					lng: position.coords.longitude
				};
				var circle = new google.maps.Circle(
				{center: geolocation, radius: position.coords.accuracy});
					autocomplete.setBounds(circle.getBounds());
				});
			}
		}
    </script>
   	<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBKmCY9-diuULK1hyHnDkElDSPT6mbfB7w&libraries=places&callback=initAutocomplete"
        async defer></script>
@endpush