@extends('layouts.bayanihan')
@section('title','My Profile')

@section('content')

    <div class="page-wrapper" style="padding-top: 60px !important">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">My Profile</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                @php
                                    $data = auth()->user()->isSuperAdmin() ? getBayanihanUser($id) : auth()->user() ;
                                @endphp
                                <li class="breadcrumb-item">
                                    <a href="{{ route('bayanihan', auth()->user()->isSuperAdmin() ? base64_encode($data->id) : '') }}">     Home (Bayanihan)
                                    </a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">My Profile</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-4 col-xlg-3 col-md-5">
                    <div class="card">
                        <div class="card-body">
                            <center>
                                <img src="{{ $user->image }}" alt="user" class="rounded-circle img-fluid" style="height: 150px !important; width: 150px !important;">
                                <h4 class="card-title m-t-10 profile-name">
                                    {{ ucwords($user->firstname.' '.$user->middlename.' '.$user->lastname) }}
                                </h4>
                                <h6 class="card-subtitle">{{ ucwords(str_replace('_', ' ', $user->member->registration_status)) }}</h6>
                            </center>
                        </div>
                        <div>
                            <hr> 
                        </div>
                        <div class="card-body">
                            <small class="text-muted">Username</small>
                            <h6>{{ $user->username }}</h6> 
                            <small class="text-muted">Email address </small>
                            <h6 class="profile-email">{{ $user->email }}</h6> 
                            <small class="text-muted">Birthdate </small>
                            <h6>{{ $user->birthdate }}</h6>
                            <small class="text-muted">Member ID </small>
                            <h6>{{ $user->member_id }}</h6>
                            <small class="text-muted">Card Number </small>
                            <h6>{{ implode('-', str_split($user->card_number, 4)) }}</h6>
                            <small class="text-muted">Referral Link </small>
                            <h6 id="referalLink">{{  route("bayanihan.referrals",base64_encode($user->member->referral_code)) }}</h6>
                            <hr>
                            <button id="copyer" class="float-right btn btn-success" onclick="copyClipboard()">copy referral link</button>
                        </div>
                    </div>
                </div>

                <div class="col-lg-8 col-xlg-9 col-md-7">
                    <div class="card">
                        <!-- Tabs -->
                        <ul class="nav nav-pills custom-pills" id="pills-tab" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" id="pills-setting-tab" data-toggle="pill" href="#previous-month" role="tab" aria-controls="pills-setting" aria-selected="false">Account Settings</a>
                            </li>
                            @role('member')
                            <li class="nav-item">
                                <a class="nav-link" id="pills-profile-tab" data-toggle="pill" href="#last-month" role="tab" aria-controls="pills-profile" aria-selected="false">Change Password</a>
                            </li>
                            @endrole
                        </ul>
                        <!-- Tabs -->
                        <div class="tab-content" id="pills-tabContent">
                            <div class="tab-pane fade show active" id="previous-month" role="tabpanel" aria-labelledby="pills-setting-tab">
                                <div class="card-body">
                                    <form class="form-horizontal form-material" id="account-settings" data-parsley-validate novalidate>
                                        @csrf
                                        <div class="row">
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>First Name</label>
                                                <input type="text" placeholder="Enter firstname" class="form-control form-control-line alpha-space" name="firstname" value="{{ $user->firstname }}" required>
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Middle Name</label>
                                                <input type="text" class="form-control form-control-line alpha-space" name="middlename" value="{{ $user->middlename }}" placeholder="Enter middlename">
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Last Name</label>
                                                <input type="text" placeholder="Enter lastname" class="form-control form-control-line alpha-space" name="lastname" value="{{ $user->lastname }}" required>
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Email*</label>
                                                <input type="text" placeholder="Enter email" class="form-control form-control-line" name="email" id="email" value="{{ $user->email }}" required>
                                                <small class="email"></small>  
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Mobile No.*</label>
                                                <input type="text" class="form-control @error('mobile_number') is-invalid @enderror" value="{{ old('mobile_number', $user->mobile_number) }}" placeholder="Enter mobile number" name="mobile_number" id="mobile_number" maxlength="13" required>
                                                <small class="mobile_number"></small>  
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Landline No.</label>
                                                <input type="text" class="form-control @error('landline_number') is-invalid @enderror" value="{{ old('landline_number', $user->landline_number) }}" placeholder="Enter landline number" name="landline_number">
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Birth Date*</label>
                                                <input type="text" class="form-control @error('birthdate') is-invalid @enderror" value="{{ old('birthdate', $user->birthdate) }}" name="birthdate" id="birthdate" required>
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Citizenship:*</label>
                                                <input type="text" class="form-control @error('citizenship') is-invalid @enderror" value="{{ old('citizenship', $user->citizenship) }}" placeholder="Enter citizenship" name="citizenship" required>
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Marital Status*</label>
                                                <select class="form-control @error('marital_status') is-invalid @enderror" name="marital_status" required>
                                                    <option value="Select Marital Status" disabled {{ old('marital_status', $user->marital_status) == 'Select Marital Status' ? 'selected' : ''}}>Select Marital Status</option>
                                                    <option value="Single" {{ old('marital_status', $user->marital_status) == 'Single' ? 'selected' : ''}}>Single</option>
                                                    <option value="Married" {{ old('marital_status', $user->marital_status) == 'Married' ? 'selected' : ''}}>Married</option>
                                                    <option value="Divorced" {{ old('marital_status', $user->marital_status) == 'Divorced' ? 'selected' : ''}}>Divorced</option>
                                                    <option value="Widowed" {{ old('marital_status', $user->marital_status) == 'Widowed' ? 'selected' : ''}}>Widowed</option>
                                                </select>
                                            </div>
                                            <div class="col-lg-8 col-12 form-group">
                                                <label>Address</label>
                                                <input type="text" class="form-control @error('address') is-invalid @enderror" id="autocomplete" onFocus="geolocate()" value="{{ old('address', $user->address) }}" placeholder="Enter address" name="address" required>
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>City/Municipality*</label>
                                                <input type="text" class="form-control @error('city') is-invalid @enderror" id="locality" value="{{ old('city', $user->city) }}" placeholder="Enter city/municipality" name="city" required>
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Street #*</label>
                                                <input type="text" class="form-control @error('street_address') is-invalid @enderror" id="street_number" value="{{ old('street_address', $user->street_address) }}" placeholder="Enter street" name="street_address" required>
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Building/Village*</label>
                                                <input type="text" class="form-control @error('building') is-invalid @enderror" id="building" value="{{ old('building', $user->building) }}" placeholder="Enter building/village" name="building" required>
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Province*</label>
                                                <input type="text" class="form-control @error('province') is-invalid @enderror" id="administrative_area_level_2" value="{{ old('province', $user->province) }}" placeholder="Enter province" name="province" required>
                                            </div>
                                            @role('member')
                                                <div class="col-12 form-group">
                                                    <button type="submit" class="btn btn-info" id="save">
                                                        <i class="mdi mdi-content-save"></i> Save
                                                    </button>
                                                </div>
                                            @endrole
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="last-month" role="tabpanel" aria-labelledby="pills-profile-tab">
                                <div class="card-body">
                                    <form class="form-horizontal form-material" id="change-password" data-parsley-validate novalidate>
                                        @csrf
                                        <div class="row justify-content-center form-group">
                                            <div class="col-lg-10 col-12">
                                                <label>Current Password</label>
                                                <input type="password" placeholder="Enter current password" class="form-control form-control-line" name="current_password" id="current_password" required>
                                                <small class="current_password"></small>                                       
                                            </div>
                                        </div>
                                        <div class="row justify-content-center form-group">
                                            <div class="col-lg-10 col-12">
                                                <label>New Password</label>
                                                <input type="password" class="form-control" name="password" id="password" placeholder="Enter new password" data-parsley-minlength="8" required>
                                            </div>
                                        </div>
                                        <div class="row justify-content-center form-group">
                                            <div class="col-lg-10 col-12">
                                                <label>Confirm Password</label>
                                                <input type="password" class="form-control" name="confirm_password" value="" id="confirm_password" placeholder="Enter confirm password" data-parsley-minlength="8" data-parsley-equalto="#password" required>                                      
                                            </div>
                                        </div>
                                        <div class="row justify-content-center form-group">
                                            <div class="col-lg-10 col-12">
                                                <button type="submit" class="btn btn-info" id="save">
                                                    <i class="mdi mdi-content-save"></i> Change Password
                                                </button>                                  
                                            </div>
                                        </div>
                                    </form>                                 
                                </div>
                            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
   <script type="text/javascript">



        // account settings
        $('form#account-settings').submit( function(e){
            e.preventDefault();

            $(this).parsley().validate();
            if ($(this).parsley().isValid()) {

                var formData = $(this).serialize();
                $.ajax({
                    type: "POST",
                    url: "{{ route('bayanihan.profile.update') }}",
                    data: formData,
                    success: function (response) {
                        $('#email').removeClass('parsley-error');
                        $('.email').removeClass('text-danger');
                        $('.email').text('');
                        $('.mobile_number').text('');
                        
                        if (response.message == 'success') {
                            let name = response.user.firstname+' '+response.user.lastname;
                            $('.profile-name').text(name);
                            $('.profile-email').text(response.user.email);

                            swal({
                                title: "Success",
                                text: 'Account updated successfully',
                                type: "success",
                                showConfirmButton: false,
                                timer: 1500
                            });
                        } else {
                            
                            if (response.message.email) {
                                $('#email').addClass('parsley-error');
                                $('.email').addClass('text-danger');
                                $('.email').text(response.message.email);
                            } else {
                                $('#mobile_number').addClass('parsley-error');
                                $('.mobile_number').addClass('text-danger');
                                $('.mobile_number').addClass('text-danger');
                                $('.mobile_number').text(response.message.mobile_number);
                            }
                        }
                    },
                    error: function (response) {
                        console.log('Error:', response);
                    }
                });
            }
        });

        // change password
        $('form#change-password').submit( function(e){
            e.preventDefault();

            $(this).parsley().validate();
            if ($(this).parsley().isValid()) {

                var formData = $(this).serialize();
                $.ajax({
                    type: "POST",
                    url: "{{ route('bayanihan.profile.update.password') }}",
                    data: formData,
                    success: function (response) {
                        if (response.message == 'success') {
                            $('#current_password').removeClass('parsley-error');
                            $('.current_password').removeClass('text-danger');
                            $('.current_password').text('');

                            $('#current_password').val('');
                            $('#password').val('');
                            $('#confirm_password').val('');
                            
                            swal({
                                title: "Success",
                                text: 'Change password successfully',
                                type: "success",
                                showConfirmButton: false,
                                timer: 1500
                            });

                        } else {
                            
                            $('#current_password').addClass('parsley-error');
                            $('.current_password').addClass('text-danger');
                            $('.current_password').text(response.message);                            
                        }
                    },
                    error: function (response) {
                        console.log('Error:', response);
                    }
                });
            }
        });
        
         // All select option
        $('select').select2({
            width : '100%'
        });

        // disabled if not super_admin
        @role('super_admin')
            $('input, select').attr('disabled',true);
            $('input, select').css('background','#fff');
            $('input, select').css('cursor','not-allowed');
        @endrole

        // Birthdate
        $('#birthdate').datepicker({
            endDate: '-5y',
            autoclose: true,
            todayHighlight: true
        });

        var placeSearch, autocomplete;

        var componentForm = {
            street_number: 'short_name',
            locality: 'long_name',
            administrative_area_level_2: 'short_name',
        };

        function initAutocomplete() {
            // Create the autocomplete object, restricting the search predictions to
            // geographical location types.
            autocomplete = new google.maps.places.Autocomplete(
            document.getElementById('autocomplete'), {types: ['geocode']});

            // Avoid paying for data that you don't need by restricting the set of
            // place fields that are returned to just the address components.
            autocomplete.setFields(['address_component']);

            // When the user selects an address from the drop-down, populate the
            // address fields in the form.
            autocomplete.addListener('place_changed', fillInAddress);
        }

        function fillInAddress() {
            // Get the place details from the autocomplete object.
            var place = autocomplete.getPlace();

            for (var component in componentForm) {
                document.getElementById(component).value = '';
                document.getElementById(component).disabled = false;
            }

            // Get each component of the address from the place details,
            // and then fill-in the corresponding field on the form.
            for (var i = 0; i < place.address_components.length; i++) {
            var addressType = place.address_components[i].types[0];
                if (componentForm[addressType]) {
                    var val = place.address_components[i][componentForm[addressType]];
                    document.getElementById(addressType).value = val;
                }
            }
        }

        // Bias the autocomplete object to the user's geographical location,
        // as supplied by the browser's 'navigator.geolocation' object.
        function geolocate() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function(position) {
                var geolocation = {
                    lat: position.coords.latitude,
                    lng: position.coords.longitude
                };
                var circle = new google.maps.Circle(
                {center: geolocation, radius: position.coords.accuracy});
                    autocomplete.setBounds(circle.getBounds());
                });
            }
        }

        function copyClipboard() {
          /* Get the text field */
          var copyText = $("#referalLink").text();

          navigator.clipboard.writeText(copyText);
          
           $("#copyer").text("copied");

        }
    </script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBKmCY9-diuULK1hyHnDkElDSPT6mbfB7w&libraries=places&callback=initAutocomplete"
        async defer></script>
@endpush
