@extends('layouts.auth')
@section('title','Reset Password')

@section('content')
    <div class="auth-wrapper d-flex no-block justify-content-center align-items-center">
        <div class="auth-box">
            <div class="logo">
                <span class="db">
                    <img src="{{ asset('admin_dashboard/img/logo.png')}}" alt="logo" width="42%" />
                </span>
                <h3 class="font-medium m-b-20 mt-4 text-center">
                    Reset Password
                </h3>
            </div>
            <form method="POST" action="{{ route('password.update') }}">
                @csrf
                <div class="row">
                    <div class="col-12">
                        @error('email')
                            <div class="alert alert-danger" role="alert">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="col-12 form-group d-none">
                        <label for="email">E-Mail Address</label>
                        <input type="hidden" name="token" value="{{ $token }}">  
                        <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus>
                    </div>
                    <div class="col-12 form-group">
                        <label for="password">New Password*</label>
                        <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password" placeholder="Enter your new password">
                        @error('password')
                            <span class="invalid-feedback" role="alert">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>
                    <div class="col-12 form-group">
                        <label for="password-confirm">Confirm Password*</label>
                        <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password" placeholder="Confirm your new password">
                    </div>
                    <div class="col-12">
                        <button type="submit" class="btn btn-info btn-block">
                            Reset My Password
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

@endsection
