@extends('layouts.auth')
@section('title','Forgot Password')

@section('content')
    <div class="auth-wrapper d-flex no-block justify-content-center align-items-center">
        <div class="auth-box">
            <div class="logo">
                <span class="db">
                    <img src="{{ asset('admin_dashboard/img/logo.png')}}" alt="logo" width="42%" />
                </span>
                <h3 class="font-medium m-b-20 mt-4 text-center">
                    Forgot your Password
                </h3>
            </div>
            <div class="row">
                <div class="col-12">
                    <form method="POST" action="{{ route('password.email') }}">
                        @csrf         
                        @if (session('status'))
                            <div class="alert alert-success" role="alert">
                                {{ session('status') }}
                            </div>
                        @endif                   
                        <div class="form-group row">
                            <div class="col-12">
                                <label for="email">E-Mail Address*</label>
                                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" placeholder="Enter your e-mail address" autofocus>
                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="text-center">
                            <div class="row">
                                <div class="col-md-12 p-b-10">
                                    <button class="btn btn-block btn-info" type="submit">
                                        Send Password Reset Link
                                    </button>
                                </div>
                            </div>
                            <div class="row p-b-10">
                                <div class="col-1"></div>
                                <div class="col-4 pr-0">
                                    <hr>
                                </div>
                                <div class="col-2 mt-1">
                                    <b>OR</b>
                                </div>
                                <div class="col-4 pl-0">
                                    <hr>
                                </div>
                            </div>
                        </div>
                        <div class="form-group text-center">
                            <div class="col-xs-12">
                                <a href="{{ route('login') }}" class="btn btn-success" type="button">
                                    Login <i class="mdi mdi-login"></i>
                                </a>
                            </div>
                        </div>                                
                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection