@extends('layouts.auth')
@section('title','Login')

@section('content')
    <div class="auth-wrapper d-flex no-block justify-content-center align-items-center" style="background:url('') no-repeat center center;">
        <div class="auth-box">
            <div id="loginform">
                <div class="logo mt-4">
                    <span class="db">
                        <img src="{{ asset('admin_dashboard/img/logo.png')}}" alt="logo" width="70%" />
                    </span>
                </div>
                <div class="row mb-4 @error('username') @else mt-4 @enderror">
                    <div class="col-12">
                        <form method="POST" action="/login" class="form-horizontal m-t-20" id="loginform">
                            @csrf

                            @error('username')
                                <div class="alert alert-danger">
                                    <i class="ti-user"></i>
                                    {{ $message }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close"> 
                                        <span aria-hidden="true">&times;</span> 
                                    </button>
                                </div>
                            @enderror
                            @error('email')
                                <div class="alert alert-danger">
                                    <i class="ti-user"></i>
                                    {{ $message }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close"> 
                                        <span aria-hidden="true">&times;</span> 
                                    </button>
                                </div>
                            @enderror

                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon1">
                                        <i class="ti-user"></i>
                                    </span>
                                </div>
                                <input type="text" name="username" id="username" class="form-control form-control-lg" placeholder="Username" value="{{ old('username')}}" aria-label="Username" aria-describedby="basic-addon1" autofocus required>
                            </div>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="basic-addon2">
                                        <i class="mdi mdi-key"></i>
                                    </span>
                                </div>
                                <input type="password" name="password" id="password" class="form-control form-control-lg" placeholder="Password" aria-label="Password" aria-describedby="basic-addon1" required>
                            </div>
                             <div class="form-group row">
                                <div class="col-md-12 text-right">
                                    @if (Route::has('password.request'))
                                        <a class="btn text-info" href="{{ route('password.request') }}">
                                            <i class="fa fa-lock m-r-5"></i> Forgot password?
                                        </a>
                                    @endif
                                </div>
                            </div>
                            <div class="text-center">
                                <div class="row">
                                    <div class="col-md-12 p-b-10">
                                        <button class="btn btn-block btn-info btn-lg" type="submit" id="login-button">
                                            Login <i class="mdi mdi-login"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>                          
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection