<?php

use Illuminate\Database\Seeder;

//Add Role Class
use Spatie\Permission\Models\Role;

//Add Models
use App\Models\AdminAccount;
use App\Models\User;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $params = [
    		'firstname' => 'PPlus',
    		'lastname' 	=> 'Superadmin',
            'username'  => 'superadmin',
    		'email' 	=> 'superadmin@email.com',
    		'password' 	=> \Hash::make('password'),
    		'usertype' 	=> 'super_admin',
    	];

    	$user = new User($params);

        $this->assignRole($user);

        if ($user->save()) {

            $params = [
                'user_id'         => $user->id,
                'employee_number' => '1234568',
                'department'      => 'MIS IT Department',
            ];

            AdminAccount::create($params);
        }
    }

     //creating user role
    public function assignRole(User $user) 
    {
        Role::findOrCreate($user->usertype);
        $user->assignRole($user->usertype);
    }
}
