<?php

use Illuminate\Database\Seeder;

//Add Models
use App\Models\Referral;
use App\Models\Member;
use App\Models\User;

//Add Role Class
use Spatie\Permission\Models\Role;

class ReferralSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        factory(User::class, 20)->create()->each(function ($user) {
            // Seed the relation with one address
            $member = factory(Member::class)->make();
            $user->member()->save($member);
            
            Role::findOrCreate($user->usertype);
            $user->assignRole($user->usertype);
        });
    }
}
