<?php

use Illuminate\Database\Seeder;

//Add Models
use App\Models\MerchantAreaCode;

class MerchantAreaCodeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $areaCodes = [
            [
            	'area_name' => 'Cebu City',
            	'area_code' => 'CEB',
            ],
            [
            	'area_name' => 'Bohol',
            	'area_code' => 'BOH',
            ],
            [
            	'area_name' => 'Negros',
            	'area_code' => 'NEG',
            ],
            [
            	'area_name' => 'Iloilo',
            	'area_code' => 'ILO',
            ],
            [
            	'area_name' => 'Manila',
            	'area_code' => 'MNL',
            ],
            [
            	'area_name' => 'Cagayan de Oro',
            	'area_code' => 'CDO',
            ],
            [
            	'area_name' => 'Butuan',
            	'area_code' => 'BXU',
            ],
        ];

        for ($i=0; $i < count($areaCodes); $i++) { 
            
            MerchantAreaCode::create([
                'area_name' => $areaCodes[$i]['area_name'],
                'area_code' => $areaCodes[$i]['area_code']
            ]);
        } 
    }
}
