<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transaction_orders', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('establishment_id');
            $table->unsignedInteger('member_id');
            $table->unsignedInteger('driver_id')->nullable();
            $table->string('driver_latitude')->nullable();
            $table->string('driver_longitude')->nullable();
            $table->string('reference_id');
            $table->string('payment_method');
            $table->double('cash_on_hand', 10, 2)->default(0.00);
            $table->string('notes')->nullable();
            $table->string('address');
            $table->string('latitude');
            $table->string('longitude');
            $table->string('status')->default('pending')->comment("'pending', 'accepted', 'prepared', 'cancelled','completed'");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transaction_orders');
    }
}
