<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('establishment_id');
            $table->unsignedInteger('product_category_id');
            $table->string('item_code');
            $table->string('name');
            $table->string('description');
            $table->double('price', 8, 2)->default(0.00);
            $table->tinyInteger('status')->default(0)->comment('0="pending", 1="approved", -1="rejected"');
            $table->unsignedInteger('auth_by');
            $table->unsignedInteger('approved_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
