<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDoctorAppointmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('doctor_appointments', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('doctor_id');
            $table->unsignedInteger('member_id');
            $table->string('reference_id');
            $table->string('appointment_id');
            $table->string('payment_method');
            $table->dateTime('date_time');
            $table->longText('notes')->nullable();
            $table->string('status')->default('pending')->comment("'pending', 'approved', 'declined', 'cancelled','completed'");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('doctor_appointments');
    }
}
