<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMerchantAgreementsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('merchant_agreements', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('merchant_id');
            $table->unsignedInteger('establishment_id');
            $table->string('application_type');
            $table->string('account_type');
            $table->double('service_fee', 5, 2)->default(0.00);
            $table->double('other_fee', 5, 2)->default(0.00);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('merchant_agreements');
    }
}
