<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePointsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('points', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('point_setting_id');
            $table->unsignedInteger('merchant_id');
            $table->unsignedInteger('member_id');
            $table->string('reference');
            $table->double('amount', 10, 2)->default(0.00);
            $table->double('points', 8, 2)->default(0.00);
            $table->double('rebate', 8, 2)->default(0.00);
            $table->double('system', 8, 2)->default(0.00);
            $table->double('upline_points', 8, 2)->default(0.00);
            $table->double('accumulated', 8, 2)->default(0.00);
            $table->double('advocacy', 8, 2)->default(0.00);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('points');
    }
}
