<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePointSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('point_settings', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('merchant_id');
            $table->double('rebate', 5, 2)->default(0.00);
            $table->double('system', 5, 2)->default(0.00);
            $table->double('accumulated', 5, 2)->default(0.00);
            $table->double('advocacy', 5, 2)->default(0.00);
            $table->double('member', 5, 2)->default(0.00);
            $table->double('upline', 5, 2)->default(0.00);
            $table->integer('upline_number')->default(0);
            $table->tinyInteger('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('point_settings');
    }
}
