<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePromotionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('promotions', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('merchant_id'); 
            $table->string('promo_code'); 
            $table->string('item_type');
            $table->integer('quantity');
            $table->longText('description');
            $table->double('points_required', 10, 2)->default(0.00);
            $table->double('discount', 5, 2)->default(0.00);
            $table->double('price', 10, 2)->default(0.00);
            $table->string('content');
            $table->tinyInteger('points_as_payment')->default(0);
            $table->double('allocation_amount', 10, 2)->default(0.00);
            $table->string('remarks');
            $table->date('date_start');
            $table->date('date_end');
            $table->tinyInteger('status')->default(0)->comment('0="pending", 1="approved", -1="rejected"');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('promotions');
    }
}
