<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMerchantsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('merchants', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('merchant_type_id');
            $table->unsignedInteger('merchant_area_code_id');
            $table->string('name');
            $table->string('email')->unique();
            $table->string('contact_number');
            $table->string('contact_person');
            $table->string('address');
            $table->string('website')->nullable();
            $table->double('mb_amount', 10, 2)->default(0)->comment('Maintaining Balance Amount');
            $table->double('mb_percent', 5, 2)->default(0)->comment('Maintaining Balance Percentage');
            $table->string('deduction_on')->default("rebate")->comment("'points', 'rebate', 'system', 'accumulated','advocacy'");
            $table->string('referral_code');
            $table->date('date_start');
            $table->date('date_end');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('merchants');
    }
}
