<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMembersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('members', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('user_id');
            $table->unsignedInteger('member_type_id');
            $table->unsignedInteger('area_code_id')->nullable();
            $table->string('member_id');
            $table->string('account_number')->nullable();
            $table->string('card_number');
            $table->date('birthdate');
            $table->string('gender');
            $table->string('citizenship');
            $table->string('marital_status');
            $table->string('mobile_number');
            $table->string('landline_number')->nullable();
            $table->string('street_address')->nullable();
            $table->string('building')->nullable();
            $table->string('city')->nullable();
            $table->string('province')->nullable();
            $table->string('address')->nullable();
            $table->string('occupation')->nullable();
            $table->string('tin_number')->nullable();
            $table->string('homeownership')->nullable();
            $table->double('total_points', 10, 2)->default(0)->nullable();
            $table->double('earned', 10, 2)->default(0)->nullable();
            $table->double('redeemed', 10, 2)->default(0)->nullable();
            $table->double('referral_points', 10, 2)->default(0)->nullable();
            $table->double('current_points', 10, 2)->default(0)->nullable();
            $table->double('amount_expense', 10, 2)->default(0)->nullable();
            $table->string('verification_code')->nullable();
            $table->string('or_number')->nullable();
            $table->string('referral_code');
            $table->date('verification_date')->nullable();
            $table->date('expiration_date')->nullable();
            $table->string('registration_status')->default('unverified');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('members');
    }
}
