<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

//Add Models
use App\Models\Promotion;

use Faker\Generator as Faker;
use Carbon\Carbon;

$factory->define(Promotion::class, function (Faker $faker) {
    return [
        'merchant_id' => rand(1,2),
        'promo_code' => $faker->randomNumber(8),
        'item_type' => 'discount',
        'quantity' => 20,
        'description' => $faker->realText(rand(20, 40)),
        'points_required' => 200,
        'discount' => 1,
        'price' => 1000,
        'content' => $faker->realText(rand(10, 20)),
        'points_as_payment' => 0,
        'allocation_amount' => 1500,
        'remarks' => $faker->realText(rand(10, 20)),
        'date_start' => Carbon::now(),
        'date_end' => Carbon::now()->addYear(),
        'status' => 1,
    ];
});
