<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

//Add Models
use App\Models\PointSetting;
use App\Models\Merchant;
use App\Models\Member;
use App\Models\Point;

use Faker\Generator as Faker;
use Carbon\Carbon;

$factory->define(Point::class, function (Faker $faker) {

    // point settings
	$point_setting_ids = PointSetting::select(['id'])->whereStatus(1)->get();
	$point_ids = [];
	foreach ($point_setting_ids as $key => $value) {
		$point_ids[] = $value->id;
	}
	$point_settingKey = array_rand($point_ids);
	$point_settingRandom = $point_ids[$point_settingKey];
	$merchant = PointSetting::find($point_settingRandom);

    // members
	$members = Member::select(['id'])->get();
    $membersIds = [];
    foreach ($members as $key => $value) {
        $membersIds[] = $value->id;
    }
    $membersKey = array_rand($membersIds);
    $memberId = $membersIds[$membersKey];
    $member = Member::find($memberId);

    return [
        'point_setting_id' => $point_settingRandom,
        'merchant_id' 	=> $merchant->merchant_id,
        'member_id'     => $member->id,
        'reference' 	=> $faker->randomElement(['meat', "sm gc's",'jollibee gc']),
        'amount' 		=> rand(100, 2000),
        'points' 		=> 0,
        'upline_points' => 0,
        'rebate' 		=> $merchant->rebate,
        'system' 		=> $merchant->system,
        'accumulated' 	=> $merchant->accumulated,
        'advocacy' 		=> $merchant->advocacy,
        'created_at' 	=> Carbon::now(),
        'updated_at' 	=> Carbon::now(),
    ];
});
