<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

//Add Models
use App\Models\PromotionLog;
use App\Models\Promotion;
use App\Models\Member;
use App\Models\User;

use Faker\Generator as Faker;
use Carbon\Carbon;

$factory->define(PromotionLog::class, function (Faker $faker) {

    // Promotions
	$promos = Promotion::select(['id'])->whereStatus(1)->get();
    $promosIds = [];
    foreach ($promos as $key => $value) {
        $promosIds[] = $value->id;
    }
    $promosKey = array_rand($promosIds);
    $promoId = $promosIds[$promosKey];
    $promo = Promotion::find($promoId);

    // Members
	$members = Member::select(['id'])->get();
    $membersIds = [];
    foreach ($members as $key => $value) {
        $membersIds[] = $value->id;
    }
    $membersKey = array_rand($membersIds);
    $memberId = $membersIds[$membersKey];
    $member = Member::find($memberId);

    // Users
	$users = User::select(['id'])->where('usertype','merchant_cashier')->whereStatus(1)->get();
    $usersIds = [];
    foreach ($users as $key => $value) {
        $usersIds[] = $value->id;
    }
    $usersKey = array_rand($usersIds);
    $userId = $usersIds[$usersKey];
    $user = User::find($userId);

    return [
        'promo_id' 		=> $promo->id,
        'member_id' 	=> $member->id,
        'user_id' 		=> $user->id,
        'allocation_amount_before' => 50000,
        'points_amount' => 0,
        'created_at' 	=> Carbon::now(),
        'updated_at' 	=> Carbon::now(),
    ];
});
