<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class Vehicle extends Model
{
    use ValidatingTrait;

 	protected $fillable = [
        'name',
		'model',
		'plate_number',
		'status',
    ];

    protected $rules = [
        'name'          => 'required|unique:vehicles,name',
        'model'  		=> 'required|string', 
        'plate_number'  => 'required|string', 
    ];

    public static function rules()
    {
        return (new static)->rules;
    }
}



