<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class SpecialityType extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'name', 
        'status',
    ];

    protected $rules = [
        'name' 	=> 'required|string|unique:speciality_types,name',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }
}
