<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class Speciality extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'speciality_type_id',
        'name',
        'description',
        'status',
    ];

    protected $rules = [
        'speciality_type_id'  => 'required|integer',
        'name' 			      => 'required|string|unique:specialities,name',
        'description'  	      => 'required|string',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function image()
    {
        return $this->hasOne(SpecialityImage::class, 'speciality_id');
    }
}
