<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class Promotion extends Model
{
    use ValidatingTrait;
    
    protected $fillable = [
        'merchant_id', 
        'promo_code', 
        'item_type',
        'quantity',
        'description',
        'points_required',
        'discount',
        'price',
        'content',
        'points_as_payment',
        'allocation_amount',
        'remarks',
        'date_start',
        'date_end',
        'status',
        'is_custom',
        'custom_type',
        'member_type_id',
        'promo_custom_member_id',
    ];

    protected $dates = [
        'date_start',
        'date_end',
    ];
    
    protected $rules = [
        'merchant_id'            => 'required|integer', 
        'promo_code'             => 'required|unique:promotions,promo_code', 
        'item_type'              => 'required|in:bundle,discount,freebies,points_of_payment,other',
        'quantity'               => 'required|integer',
        'description'            => 'required|string',
        'points_required'        => 'required|integer',
        'discount'               => 'required|integer',
        'price'                  => 'required|integer',
        'content'                => 'required|string',
        'points_as_payment'      => 'nullable|in:1,0',
        'allocation_amount'      => 'required|integer',
        'remarks'                => 'required|string',
        'date_start'             => 'required|date',
        'date_end'               => 'required|date',
        'status'                 => 'nullable|in:0,1,-1',
        'is_custom'              => 'nullable|in:0,1',
        'custom_type'            => 'nullable|in:promo_members,promo_member_types',
        'member_type_id'         => 'nullable|integer',
        'promo_custom_member_id' => 'nullable|integer',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function promoImages()
    {
        return $this->hasMany(PromotionImage::class, 'promo_id');
    }

    public function promoMembers()
    {
        return $this->hasMany(PromoMember::class, 'promo_id');
    }

    public function promoMemberTypes()
    {
        return $this->hasMany(PromoMemberType::class, 'promo_id');
    }
}
