<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class Product extends Model
{
    use ValidatingTrait;

    protected $injectUniqueIdentifier = true;

 	protected $fillable = [
        'establishment_id', 
        'product_category_id', 
        'item_code', 
        'name', 
        'description', 
        'price', 
        'status', 
        'auth_by', 
        'approved_by', 
    ];

    protected function prepareUniqueIdsRule($parameters, $field)
    {
        // Only perform a replacement if the model has been persisted.
        if ($this->exists) {
            return 'establishment_id:' . $this->getKey();
        }

        return 'establishment_id';
    }

    protected $rules = [
        'establishment_id'   => 'required|integer', 
        'product_category_id'=> 'required|integer', 
        'item_code'  	     => 'required|string', 
        'name'               => 'required|string',
        'description'  	     => 'required|string', 
        'price'  		     => 'required|integer', 
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function image() {
        return $this->hasOne(ProductImage::class, 'product_id', 'id');
    }
}