<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class Point extends Model
{
 	use ValidatingTrait;

 	protected $fillable = [
        'point_setting_id', 
        'user_id', 
        'reference',
        'amount',
        'points',
        'rebate',
        'system',
        'upline_points',
        'accumulated',
        'advocacy',
    ];

    protected $rules = [
        'point_setting_id'  => 'required|integer', 
        'user_id'  		    => 'required|integer', 
        'reference'  		=> 'required|string', 
        'amount'  			=> 'required|integer',
        'points'			=> 'required|integer',
        'rebate'			=> 'required|integer',
        'system'			=> 'required|integer',
        'upline_points'		=> 'required|integer',
        'accumulated'		=> 'required|integer',
        'advocacy'			=> 'required|integer',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function user() {
        return $this->hasOne(User::class , 'id', 'user_id');
    }

    public function merchant() {
        return $this->hasOne(Merchant::class,'id','merchant_id');
    }
}