<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class PaymentMethod extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'merchant_agreement_id',
        'name',
    ];

    protected $rules = [
        'merchant_agreement_id'	=> 'required|integer',
        'name'  				=> 'required|string',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }
}
