<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class Order extends Model
{
    use ValidatingTrait;

 	protected $fillable = [
        'transaction_order_id', 
        'product_id', 
        'quantity', 
    ];

    protected $rules = [
        'transaction_order_id'  => 'required|integer',
        'product_id'  			=> 'required|integer', 
        'quantity'  			=> 'required|integer',         
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function product() {
        return $this->hasOne(Product::class, 'id', 'product_id');
    }
}