<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class MerchantReview extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'merchant_id',
        'member_id',
        'transaction_order_id',
        'rate',
        'comment'
    ];
    
    protected $rules = [
        'merchant_id'          => 'required|integer',
        'member_id'			   => 'required|integer',
        'transaction_order_id' => 'required|integer',
        'rate'	 			   => 'required|in:1,2,3,4,5',       
        'comment'	 		   => 'nullable|string',       
    ];

    public static function rules()
    {
        return (new static)->rules;
    }
}

