<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class MerchantImage extends Model
{
    protected $fillable = [
        'merchant_id',
        'title',
        'type',
        'path',
        'size'
    ];

    /* @array $appends */
    public $appends = [
        'url',
        'uploaded_time',
        'size_in_kb'
    ];

    public function getUrlAttribute()
    {
        return Storage::disk('s3')->url($this->path);
    }

    public function getUploadedTimeAttribute()
    {
        return $this->created_at->diffForHumans();
    }

    public function merchant()
    {
        return $this->belongsTo(Merchant::class, 'merchant_id');
    }

    public function getSizeInKbAttribute()
    {
        return round($this->size / 1024, 2);
    }
}
