<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class MerchantCashier extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'user_id',
        'merchant_id',
        'cashier_id',
        'employee_number',
        'department',
        'contact_number',
    ];

    protected $rules = [
        'user_id'         	=> 'required|integer',
        'merchant_id'       => 'required|integer',
        'cashier_id'   		=> 'required',
        // 'employee_number'   => 'required|unique:merchant_cashiers,employee_number',
        'department'       	=> 'required|regex:/^[a-zA-Z\s]*$/',
        'contact_number'    => ['nullable','regex:/^(09|\+639)\d{9}$/', 'unique:merchant_cashiers,contact_number'],
    ];
    
    // Custom validation rules
    protected $validationMessages = [
        'contact_number.regex' => "Mobile number is invalid."
    ];
    
    public static function rules()
    {
        return (new static)->rules;
    }

    public function setContactNumberAttribute($contactNumber)
    {   
        if (\Str::startsWith($contactNumber, '9')) {
            $contactNumber = '0'.$contactNumber;
        }
        $this->attributes['contact_number'] = $contactNumber;
    }
}
