<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class MerchantAreaCode extends Model
{
    use ValidatingTrait;
    
    protected $fillable = [
        'area_name', 
        'area_code', 
        'status',
    ];

    protected $rules = [
        'area_name' => 'required|string|unique:merchant_area_codes,area_name',
        'area_code' => 'required|string',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }
}
