<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class Driver extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'user_id',
        'vehicle_id',
        'merchant_id',
        'professional_id',
        'contact_number',
    ];
    
    protected $rules = [
        'user_id'      		=> 'required|integer',
        'vehicle_id'        => 'required|integer',     
        'merchant_id'      	=> 'nullable|integer',
        'professional_id'	=> 'required|string',     
        'contact_number'    => ['nullable','regex:/^(09|\+639)\d{9}$/'],
    ];

    // Custom validation rules
    protected $validationMessages = [
        'contact_number.regex' => "Mobile number is invalid."
    ];
    
    public static function rules()
    {
        return (new static)->rules;
    }

    public function setContactNumberAttribute($contactNumber)
    {   
        if (\Str::startsWith($contactNumber, '9')) {
            $contactNumber = '0'.$contactNumber;
        }
        $this->attributes['contact_number'] = $contactNumber;
    }

    public function image()
    {
        return $this->belongsTo(DriverImage::class, 'id', 'driver_id');
    }

    public function vehicle() {
        return $this->hasOne(Vehicle::class, 'id', 'vehicle_id');
    }

    public function user() {
        return $this->hasOne(User::class, 'id', 'user_id');
    }
}
