<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class DoctorSchedule extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'doctor_id',
        'monday',
        'tuesday',
        'wednesday',
        'thursday',
        'friday',
        'saturday',
        'sunday',
    ];
    
    protected $rules = [
        'doctor_id'     => 'required|integer|unique:doctor_schedules,doctor_id',
        'monday'	 	=> 'nullable',       
        'tuesday'	 	=> 'nullable',       
        'wednesday'	 	=> 'nullable',       
        'thursday'	 	=> 'nullable',       
        'friday'	 	=> 'nullable',       
        'saturday'	 	=> 'nullable',       
        'sunday'	 	=> 'nullable',       
    ];

    public static function rules()
    {
        return (new static)->rules;
    }
}