<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class DoctorReview extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'appointment_id',
        'user_id',
        'rate',
        'comment',
    ];
    
    protected $rules = [
        'appointment_id'	=> 'required|integer',
        'user_id'           => 'required|integer',
        'rate'	 			=> 'required|in:1,2,3,4,5',       
        'comment'	 		=> 'nullable|string',       
    ];

    public static function rules()
    {
        return (new static)->rules;
    }
}
