<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class DoctorPaymentMethod extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'doctor_id',
        'name',
    ];
    
    protected $rules = [
        'doctor_id'		=> 'required|integer',
        'name'	 		=> 'required|string',       
    ];

    public static function rules()
    {
        return (new static)->rules;
    }
}
