<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class DoctorImage extends Model
{
   	/* Fillable */
    protected $fillable = [
        'doctor_id',
        'title',
        'path',
        'size'
    ];

    /* @array $appends */
    public $appends = [
        'url',
        'uploaded_time',
        'size_in_kb'
    ];

    public function getUrlAttribute()
    {
        return Storage::disk('s3')->url($this->path);
    }

    public function getUploadedTimeAttribute()
    {
        return $this->created_at->diffForHumans();
    }

    public function doctor()
    {
        return $this->belongsTo(Doctor::class, 'doctor_id');
    }

    public function getSizeInKbAttribute()
    {
        return round($this->size / 1024, 2);
    }
}
