<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class DoctorAppointment extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'doctor_id',
        'user_id',
        'reference_id',
        'appointment_id',
        'payment_method',
        'date_time',
        'notes',
        'status',
        'hmo_id',
    ];
    
    protected $rules = [
        'doctor_id'		=> 'required|integer',
        'user_id'		=> 'required|integer',
        'reference_id'  => 'required|string',
        'appointment_id'=> 'required|string',
        'payment_method'=> 'required|string',
        'date_time'	 	=> 'required|date_format:Y-m-d H:i:s', 
        'status'        => 'required|in:pending,approved,declined,cancelled,completed',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function doctor() {
        return $this->hasOne(Doctor::class, 'id', 'doctor_id');
    }
}
