<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class Cashier extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'user_id',
        'cashier_id',
        'employee_number',
        'department',
        'contact_number',
    ];

    protected $rules = [
        'image'             => 'nullable|mimes:jpeg,jpg,png|max:10000',
        'user_id'         	=> 'required|integer',
        'cashier_id'        => 'required|unique:cashiers,cashier_id',
        'employee_number'   => 'required|string|unique:cashiers,employee_number',
        'department'       	=> 'required|regex:/^[a-zA-Z\s]*$/',
        'contact_number'    => ['nullable','regex:/^(09|\+639)\d{9}$/', 'unique:cashiers,contact_number'],
    ];

    // Custom validation rules
    protected $validationMessages = [
        'contact_number.regex' => "Mobile number is invalid."
    ];

    public static function rules()
    {
        return (new static)->rules;
    }

    public function setContactNumberAttribute($contactNumber)
    {   
        if (\Str::startsWith($contactNumber, '9')) {
            $contactNumber = '0'.$contactNumber;
        }
        $this->attributes['contact_number'] = $contactNumber;
    }
}
