<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Watson\Validating\ValidatingTrait;

class AdminPointSetting extends Model
{
    use ValidatingTrait;

    protected $fillable = [
        'qualified_points', 
        'status',
    ];

    protected $rules = [
        'qualified_points' 	=> 'required|integer|unique:admin_point_settings,qualified_points',
        'status'            => 'nullable|in:0,1',
    ];

    public static function rules()
    {
        return (new static)->rules;
    }
}
