<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendReferralLink extends Mailable
{
    use Queueable, SerializesModels;

    protected $data;

    public function __construct($data)
    {   
        $this->data = $data;
    }

    public function build()
    {
        return $this->view('emails.send-referral')
                    ->with(['data' => $this->data]);
    }
}
