<?php

namespace App\Http\Middleware;

use Closure;

class LogoutDeactivated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if(auth()->user()->status == 0) {
            $message = 'Account already deactivated.';
            return $this->authenticatedLogout($request, $message);
        }
        return $next($request);
    }

    //custom authenticated logout
    public function authenticatedLogout($request, $message)
    {
        auth()->logout();
        $request->session()->invalidate();
        return redirect('/login')
            ->withInput()
            ->withErrors(['username' => $message]);
    }
}
