<?php

namespace App\Http\Middleware;

use Redirect;
use Closure;

class AuthenticateAsMerchantAdminKolA
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (auth()->user()->isMerchantAdmin()) {
            if (auth()->user()->account->merchant->is_mobile != 1) {
                return Redirect::route('dashboard');
            }
            if (auth()->user()->account->merchant->merchantAgreement->application_type != 'kol-a') {
                return Redirect::route('dashboard');
            }
        }
        return $next($request);
    }
}
