<?php

namespace App\Http\Middleware;

use Redirect;
use Closure;

class AuthenticateAsMember
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {   
        if (is_null(auth()->user()->member) && auth()->user()->isMember()) {
            return Redirect::route('bayanihan.complete.profile');
        }
        return $next($request);
    }
}
