<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Member;
use App\Models\Referral;

use DB;
use Hash;

class ImportController extends Controller
{
    public function index() {
    	return view('import');
    }

    public function create(Request $request) {
    	ini_set('max_execution_time', 0);
    	ini_set('memory_limit', '-1');

    	$fields = [
    		"member_type_id" => 47,
		    "area_code_id" => 19,
		    "member_id" => 0,
		    "card_number" => 20,
		    "birthdate" => 4,
		    "gender" => 5,
		    "citizenship" => 7,
		    "marital_status" => 8,
		    "mobile_number" => 9,
		    "landline_number" => 10,
		    "address" => 11,
		    "occupation" => 12,
		    "tin_number" => 14,
		    "homeownership" => 18,
		    "total_points" => 22,
		    "earned" => 23,
		    "redeemed" => 24,
		    "referral_points" => 25,
		    "current_points" => 26,
		    "amount_expense" => 29,
		    "or_number" => 33,
		    "referral_code" => 46,
		    "verification_date" => 36,
		    "expiration_date" => 28,
		    "registration_status" => 35,
		    "username" => 38,
		    "password" => 37,
		    "firstname" => 1,
		    "middlename" => 2,
		    "lastname" => 3,
		    "email" => 6
    	];

    	$path = $request->file('data')->getRealPath();
    	$data = array_map('str_getcsv', file($path));

    	unset($data[0]);
    	$divide = count($data) / 26.38;

    	foreach ($data as $key => $value) {

    		DB::beginTransaction();

    		$email = str_replace([" ",","], "", $value[$fields["email"]]);

    		if($value[$fields["email"]] == "NULL" || strlen($value[$fields["email"]]) < 5 || $value[$fields["email"]] == "") {
    			$email = str_replace([" ",",","."], "", strtolower($value[$fields["firstname"]][0]).strtolower($value[$fields["lastname"]])).$key.'@gmail.com';
    		}

    		if(!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    			$email = str_replace([" ",",","."], "", strtolower($value[$fields["firstname"]][0]).strtolower($value[$fields["lastname"]])).$key.'@gmail.com';
    		}

    		if (User::where('email', '=', $email)->count() > 0) {
			   $email = str_replace([" ",",","."], "", strtolower($value[$fields["firstname"]][0]).strtolower($value[$fields["lastname"]])).$key.'@gmail.com';
			}

    		$username = preg_replace('/\s+/', '', $value[$fields["username"]]);
    		if(strlen($username) < 7) {
    			$username = preg_replace('/\s+/', '', $value[$fields["username"]]).$key."plus";
    		}

    		if (User::where('username', '=', $username)->count() > 0) {
			   $username = preg_replace('/\s+/', '', $value[$fields["username"]]).$key."plus";
			} 

    		$password = $value[$fields["password"]];
    		if(strlen($password) < 7) {
    			$password = "primaryplus";
    		} 

	    	$user_params = [
	    		'firstname' => $value[$fields["firstname"]],
	    		'middlename' => $value[$fields["middlename"]],
	    		'lastname' => $value[$fields["lastname"]],
	    		'username' => $username,
	    		'email' => $email,
	    		'password' => Hash::make($password),
	    		'usertype' => "member"
	    	];

	    	$user = new User($user_params);

	    	$member_type_id = $value[$fields["member_type_id"]];
    		if($member_type_id == null || $member_type_id == 0) {
    			$member_type_id = 1;
    		}

    		$area_code = $value[$fields["area_code_id"]];
    		if($area_code == null || $area_code == 0) {
    			$area_code = 2;
    		}

    		$member_id = $value[$fields["member_id"]];

    		if($member_id == null || $member_id == 0 || $member_id < 5) {
    			$member_id = $this->generateMemberId();
    		}

    		if (Member::where('member_id', '=', $member_id)->count() > 0) {
			   $member_id = $this->generateRandomMemberId();
			}

    		$card_number = $value[$fields["card_number"]];
    		if($card_number == null || $card_number == 0 || $card_number < 5) {
    			$card_number = $this->generateCardNumber();
    		}

    		$verification_date = $value[$fields["verification_date"]];
    		if($verification_date == "0000-00-00 00:00:00" || $verification_date == "NULL" || $verification_date == "0000-00-00") {
    			$verification_date = null;
    		}

    		$expiration_date = $value[$fields["expiration_date"]];
    		if($expiration_date == "0000-00-00 00" || $expiration_date == "NULL" || $expiration_date == "0000-00-00") {
    			$expiration_date = null;
    		}

    		$gender = $value[$fields["gender"]];
    		if($gender == "" || $gender == null) {
    			$gender = $this->generateRandomGender();
    		}

    		$total_points = $value[$fields["total_points"]];
    		if($total_points == NULL || $total_points == '' || $total_points == 'NULL') {
    			$total_points = 0;
    		}

    		$earned = $value[$fields["earned"]];
    		if($earned == NULL || $earned == '' || $earned == 'NULL') {
    			$earned = 0;
    		}

    		$redeemed = $value[$fields["redeemed"]];
    		if($redeemed == NULL || $redeemed == '' || $redeemed == 'NULL') {
    			$redeemed = 0;
    		}

    		$referral_points = $value[$fields["referral_points"]];
    		if($referral_points == NULL || $referral_points == '' || $referral_points == 'NULL') {
    			$referral_points = 0;
    		}

    		$current_points = $value[$fields["current_points"]];
    		if($current_points == NULL || $current_points == '' || $current_points == 'NULL') {
    			$current_points = 0;
    		}

    		$amount_expense = $value[$fields["amount_expense"]];
    		if($amount_expense == NULL || $amount_expense == '' || $amount_expense == 'NULL') {
    			$amount_expense = 0;
    		}

    		$birthdate = $value[$fields["birthdate"]];
    		if($birthdate == NULL || $birthdate == 'NULL' || $birthdate == "0000-00-00") {
    			$birthdate = "1/1/1970";
    		}

    		$referral_code = $value[$fields["referral_code"]];
    		if($referral_code == NULL || $referral_code == 'NULL') {
    			$referral_code = $this->generateReferralCode();
    		}

    		if (Member::where('referral_code', '=', $referral_code)->count() > 0) {
			   $referral_code = $this->generateReferralCode();
			} 

	    	if ($user->save()) {
	    		$params = [
			        'member_type_id' => $member_type_id,
			        'area_code_id' => $area_code,
			        'member_id' => $member_id,
			        'card_number' => $card_number,
			        'birthdate' => $birthdate,
			        'gender' => $gender,
			        'citizenship' => $value[$fields["citizenship"]],
			        'marital_status' => $value[$fields["marital_status"]],
			        'mobile_number' => $value[$fields["mobile_number"]],
			        'landline_number' => $value[$fields["landline_number"]],
			        'street_address' => '',
			        'building' => '',
			        'city' => '',
			        'province' => '',
			        'address' => $value[$fields["address"]],
			        'occupation' => $value[$fields["occupation"]],
			        'tin_number' => $value[$fields["tin_number"]],
			        'homeownership' => $value[$fields["homeownership"]],
			        'total_points' => $total_points,
			        'earned' => $earned,
			        'redeemed' => $redeemed,
			        'referral_points' => $referral_points,
			        'current_points' => $current_points,
			        'amount_expense' => $amount_expense,
			        'or_number' => $value[$fields["or_number"]],
			        'referral_code' => $referral_code,
			        'verification_date' => $verification_date,
			        'expiration_date' => $expiration_date,
			        'registration_status' => $value[$fields["registration_status"]]
	    		];

	    		$params['user_id'] = $user->id;
	            $member = new Member($params);

	            if (!$member->save()) {
	    			// Rollback and then redirect & back to form with errors
	   				DB::rollback();
					\Log::info('KEY '.$key.' ERROR MEMBER '.$member->getErrors().' WHO '.json_encode($member));
					break;
				}

	            //ASSIGN ROLE
	            $this->assignRole($user);

	            $rcode = Member::where('referral_code', $referral_code)->orderBy('id', 'desc')->first();
	            if($rcode->user_id){
	            	if($rcode->user_id != $user->id) {
	            		$referral_params = [
		            		'user_id' => $user->id,
		            		'user_upline_id' => $rcode->user_id
		            	];
		            	$refferral = new Referral($referral_params);
		            	$refferral->save();
	            	}
	            }

	            DB::commit();
	    	} else {
	    		\Log::info('KEY '.$key.' ERROR USER '.$user->getErrors().' WHO '.json_encode($user));
    			break;
	    	}
    		if($key == $divide) {
    			sleep(2);
    		}
    	}
    	dd('done');
    }

    // Generate Member ID according based on last member_id
    public function generateMemberId()
    {
        $generated_id = Member::select(['member_id'])
            ->orderBy('id','desc')
            ->first();

        return $generated_id['member_id'] + 1;
    }

    public function generateRandomMemberId() {
    	return $randomNum = substr(str_shuffle("0123456789"), 0, 9);
    }

    // Generate Card Number
    public function generateCardNumber()
    {   
        $code = $this->generateNumericCode();
        $member = Member::where('card_number', $code)->first();

        if (isset($member)) {
            $this->generateNumericCode();
        }
        
        return $code;
    }

    // Generate 16 digits Numberic Code
    public function generateNumericCode()
    {
        $code = '';
        for($i = 0; $i < 16; $i++) { 
            $code .= mt_rand(0, 9); 
        }

        return $code;
    }

    public function generateRandomGender() {
    	$genders = ["Male", "Female"];
    	$randIndex = array_rand($genders);
    	return $genders[$randIndex];
    }

    // Generate Referral Code
    public function generateReferralCode()
    {
        $code = $this->generateAlphaNumeric(7);
        $member = Member::where('referral_code', $code)->first();

        if (isset($member)) {
            $this->generateAlphaNumeric(7);
        }    

        return $code;
    }

    // Generate Alpha Numberic
    public function generateAlphaNumeric($limit)
    {
        $code = substr(base_convert(sha1(uniqid(mt_rand())), 16, 36), 0, $limit);

        return strtoupper($code);
    }

    public function referral(Request $request) {
    	ini_set('max_execution_time', 0);
    	ini_set('memory_limit', '-1');

    	$fields = [
    		"user_id" => 0,
		    "up_code" => 1
    	];

    	$path = $request->file('data')->getRealPath();
    	$data = array_map('str_getcsv', file($path));
    	unset($data[0]);
    	$divide = count($data) / 26.38;
		
		foreach ($data as $key => $value) {
			$up_code = $value[$fields["up_code"]];
			$user_id = $value[$fields["user_id"]];
			if($up_code != "" || $up_code != null || $up_code != "NULL") {
	    		$rcode = Member::where('referral_code', $up_code)->first();
	            if(isset($rcode->user_id)){
	            	if($rcode->user_id != $user_id) {
	            		$referral_params = [
		            		'user_id' => $user_id,
		            		'user_upline_id' => $rcode->user_id
		            	];
		            	$refferral = new Referral($referral_params);
		            	$refferral->save();
	            	}
	            }
	        }
	        if($key == $divide) {
    			sleep(2);
    		}
    		continue;
    	}
    }
}
