<?php

namespace App\Http\Controllers\Dashboard\Settings\MerchantVehicle;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add External Classes
use Yajra\Datatables\Datatables;

//Add Models
use App\Models\Vehicle;

class ViewController extends Controller
{
    public function index()
    {   
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Merchant Vehicle View',
            'reference_id' => null,
            'table' => 'vehicles',
            'remarks' => 'Merchant Vehicle View Success',
        ];

        $this->addLogs($params);

    	return view('dashboard.settings.merchant-vehicles.index');
    }

    public function merchantVehicleList()
    {
    	$vehicles = Vehicle::latest()->get();

        return Datatables::of($vehicles)
            ->addIndexColumn()
            ->addColumn('name', function($vehicle){
                return ucwords($vehicle->name);
            })
            ->addColumn('model', function($vehicle){
                return ucwords($vehicle->model);
            })
            ->addColumn('plate_number', function($vehicle){
                return ucwords($vehicle->plate_number);
            })
            ->addColumn('status', function($vehicle){
               	$status = $vehicle->status == 1 ? 
                    '<i class="mdi mdi-checkbox-blank-circle text-success"></i> Active' :
                    '<i class="mdi mdi-checkbox-blank-circle text-danger"></i> Inactive' ;
                return $status;
            })
            ->addColumn('created_at', function($vehicle){
                return $vehicle->created_at->format('M d,Y h:i:s A');
            })
            ->addColumn('action', function ($vehicle){
                $status = $vehicle->status == 1 ? 'Deactivate' : 'Activate';
                $button = '<a href='.route('merchants.vehicles.edit',base64_encode($vehicle->id)).' id="edit">
                                <button class="btn btn-sm btn-primary mr-1"> 
                                    <i class="mdi mdi-table-edit"></i> Edit
                                </button>
                            </a>';
                $button .= $vehicle->status == 1 ?
                    '<a href='.route('merchants.vehicles.status',base64_encode($vehicle->id)).' id="status" data-status='.$status.'>
                        <button class="btn btn-sm btn-danger"> 
                            <i class="mdi mdi-minus-circle"></i> Deactivate
                        </button>
                    </a>':
                    '<a href='.route('merchants.vehicles.status',base64_encode($vehicle->id)).' id="status" data-status='.$status.'>
                        <button class="btn btn-sm btn-success pl-3 pr-3"> 
                            <i class="mdi mdi-check-circle"></i> Activate
                        </button>
                    </a>';

            	$action = '<div style="display:flex">
                                '.$button.'
            			   </div>';
            	return $action;
            })
        	->escapeColumns([])->make(true);
    }

    public function edit($id)
    {
        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Vehicle View',
            'reference_id' => base64_decode($id),
            'table' => 'categories',
            'remarks' => 'Success viewing edit vehicle.',
        ];
        
        $this->addLogs($params);

        return Vehicle::find(base64_decode($id));
    }
}
