<?php

namespace App\Http\Controllers\Dashboard\Settings\MerchantVehicle;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\Vehicle;
use App\Models\Driver;
use App\Models\User;

class UpdateController extends Controller
{
    public function index(Request $request)
    {	
    	$params = $request->all();
        $record = Vehicle::find($params['vehicle_id']);

        if ($record->update($params)) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Vehicle Update',
                'reference_id' => $record->id,
                'table' => 'vehicles',
                'remarks' => 'Success updating vehicle.',
            ];

            $this->addLogs($params);

    		return response()->json(['message' => 'success'],200);	
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Vehicle Update',
            'reference_id' => null,
            'table' => 'vehicles',
            'remarks' => 'Error updating vehicle.',
        ];

        $this->addLogs($params);

    	return response()->json(['message' => $record->getErrors()]);
    }

    public function status($id)
    {
        $areaCode = Vehicle::find(base64_decode($id));

        if ($areaCode->status == 1) {
        	
        	$areaCode->update(['status' => 0]);

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Vehicle and Driver Deactivation',
                'reference_id' => base64_decode($id),
                'table' => 'vehicles && drivers',
                'remarks' => 'Success deactivating vehicle.',
            ];
            
            $this->addLogs($params);

            $driver = Driver::where('vehicle_id',base64_decode($id))->first();
            User::where('id', $driver->user_id)->update(['status' => 0]);

        	return response()->json(['message' => 'Vehicle deactivated successfully']);
        }

       	$areaCode->update(['status' => 1]);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Vehicle Activation',
            'reference_id' => base64_decode($id),
            'table' => 'vehicles',
            'remarks' => 'Success activating vehicle.',
        ];

        $this->addLogs($params);

        return response()->json(['message' => 'Vehicle activated successfully']);
    }
}
