<?php

namespace App\Http\Controllers\Dashboard\Settings\MerchantVehicle;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\Vehicle;

class CreateController extends Controller
{
    public function index(Request $request)
    {
    	$params = $request->all();
    	unset($params['vehicle_id']);
        $record = new Vehicle($params);

    	if (!$record->save()) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Vehicle Registration',
                'reference_id' => null,
                'table' => 'vehicles',
                'remarks' => 'Error registering vehicle.',
            ];

            $this->addLogs($params);

    		return response()->json(['message' => $record->getErrors()]);
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Vehicle Registration',
            'reference_id' => $record->id,
            'table' => 'vehicles',
            'remarks' => 'Success registering vehicle.',
        ];

        $this->addLogs($params);
        
    	return response()->json(['message' => 'success'],200);	
    }
}
