<?php

namespace App\Http\Controllers\Dashboard\Settings\MerchantType;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\MerchantType;

class UpdateController extends Controller
{
    public function index(Request $request)
    {	
    	$params = $request->all();
        $record = MerchantType::find($params['merchant_id']);

        if ($record->update($params)) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Merchant Type Update',
                'reference_id' => $record->id,
                'table' => 'merchant_types',
                'remarks' => 'Success updating merchant type.',
            ];
            
            $this->addLogs($params);

    		return response()->json(['message' => 'success'],200);	
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Merchant Type Update',
            'reference_id' => $record->id,
            'table' => 'merchant_types',
            'remarks' => 'Failed updating merchant type.',
        ];
        
        $this->addLogs($params);

        return response()->json(['message' => $record->getErrors()]);
    }

    public function status($id)
    {
        $merchantType = MerchantType::find(base64_decode($id));

        if ($merchantType->status == 1) {
        	
        	$merchantType->update(['status' => 0]);

            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Merchant Type Deactivation',
                'reference_id' => base64_decode($id),
                'table' => 'merchant_types',
                'remarks' => 'Merchant Type deactivated successfully',
            ];
            
            $this->addLogs($params);

        	return response()->json(['message' => 'Member Type deactivated successfully']);
        }

       	$merchantType->update(['status' => 1]);

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Merchant Type Activation',
            'reference_id' => base64_decode($id),
            'table' => 'merchant_types',
            'remarks' => 'Merchant Type activated successfully',
        ];
        
        $this->addLogs($params);
        
        return response()->json(['message' => 'Member Type activated successfully']);
    }
}
