<?php

namespace App\Http\Controllers\Dashboard\Settings\MerchantType;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

//Add Models
use App\Models\MerchantType;

class CreateController extends Controller
{
    public function index(Request $request)
    {
    	$params = $request->all();
    	unset($params['merchant_id']);
        $record = new MerchantType($params);

    	if (!$record->save()) {
            $params = [
                'user_id' => auth()->user()->id, 
                'activity' => 'Merchant Type Register',
                'reference_id' => null,
                'table' => 'merchant_types',
                'remarks' => 'Failed registering merchant type.',
            ];
            
            $this->addLogs($params);

    		return response()->json(['message' => $record->getErrors()]);
    	}

        $params = [
            'user_id' => auth()->user()->id, 
            'activity' => 'Merchant Type Register',
            'reference_id' => $record->id,
            'table' => 'merchant_types',
            'remarks' => 'Success registering merchant type.',
        ];

        $this->addLogs($params);

    	return response()->json(['message' => 'success'],200);	
    }
}
